/*
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Contributors:
 *      Dino Octavian - initial API and implementation
 */
package gloodb;

import gloodb.GlooException;

/**
 * Thrown when trying to update an object which doesn't exist in the repository.
 */
public class PersistentNotFoundException extends GlooException {
	private static final long serialVersionUID = 8916916072970892332L;
	
	/**
	 * Creates an exception message.
	 */
	public PersistentNotFoundException() {
		super();
	}

	/**
	 * Creates an exception with a message
	 * @param message The message
	 */
	public PersistentNotFoundException(String message) {
		super(message);
	}
}
